 #using wmGUI
FUNCTION Start() AS VOID
	LOCAL o1 AS RightSLE
	LOCAL o2 AS RightSLE

	? "This is rightSLE's initial default setting for processing Enter:",RightSLE.DefaultProcessEnter
	? "This is rightSLE's initial default setting for processing Arrow:",RightSLE.DefaultProcessArrow
	? "   This is rightSLE's initial default setting for the InsertKey:",RightSLE.DefaultOverwrite
	?

	? "Changing RightSLE's defaults"
	SetupRightSLE()

	? "This is rightSLE's current default setting for processing Enter:",RightSLE.DefaultProcessEnter
	? "This is rightSLE's current default setting for processing Arrow:",RightSLE.DefaultProcessArrow
	? "   This is rightSLE's current default setting for the InsertKey:",RightSLE.DefaultOverwrite
	?

	o1 := RightSLE{}
	o2 := RightSLE{}

	? "Initial effective Arrow behaviour on o1:",o1:EffectiveProcessArrow
	? "Initial effective Arrow behaviour on o2:",o2:EffectiveProcessArrow
	?
	
	? "Changing o1's Arrow setting to Process"
	o1:ProcessArrow := KeyHandling.Process
	? "Current effective Arrow behaviour on o1:",o1:EffectiveProcessArrow
	? "Current effective Arrow behaviour on o2:",o2:EffectiveProcessArrow
	?

	? "Changing o1's Arrow setting to Auto"
	o1:ProcessArrow := KeyHandling.Auto
	? "Current effective Arrow behaviour on o1:",o1:EffectiveProcessArrow
	? "Current effective Arrow behaviour on o2:",o2:EffectiveProcessArrow
	?

    wait
    
	RETURN

FUNCTION SetupRightSLE() AS VOID

	RightSLE.DefaultProcessEnter        := KeyHandling.Process
	RightSLE.DefaultProcessArrow        := KeyHandling.Ignore
	RightSLE.DefaultOverwrite           := OverwriteBehavior.OnKey

	RETURN
